using System;
using System.IO;
using System.Xml;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace BeWise.SharpBuilderTools.Ant
{
	public abstract class BaseAntProject
	{
		// *************************************************************************
		//                           Constructor
		// *************************************************************************

		public BaseAntProject(string aFileName)
		{
			if (!File.Exists(aFileName)) {
				throw new Exception("Expected valid FileName: " + aFileName);
			}

			fFileName = aFileName;

			fXml = new XmlDocument();
			fXml.Load(fFileName);

			FillAntProject();

		}

		// *************************************************************************
		//                               Private
		// *************************************************************************

		private string fDefault;
		private string fFileName;
		private string fProjectName;
		private BaseAntProperty[] fProperties;
		private BaseAntTarget[] fTargets;
		private XmlDocument fXml;

		// *************************************************************************
		//                               Protected
		// *************************************************************************

		protected virtual BaseAntProperty BuildAntProperty(XmlNode aNode) {
            string _Name = "";
            string _Value = "";
            XmlAttribute _Attr = null;

            _Attr = (XmlAttribute) aNode.Attributes.GetNamedItem("name");

            if (_Attr != null) {
                _Name = _Attr.Value; 
			} else {
				_Name = "Undefined";
			}

            _Attr = (XmlAttribute) aNode.Attributes.GetNamedItem("value");

            if (_Attr != null) {
                _Value = _Attr.Value; 
            } 

            BaseAntProperty _result = CreateAntProperty(_Name, _Value);

            return _result;
        }

        protected virtual BaseAntProperty[] BuildAntProperties() {
            ArrayList _ls = new ArrayList();
            BaseAntProperty[] _result;

            XmlNode _Root = null;

            _Root = fXml.DocumentElement;

            for (int i = 0; i < _Root.ChildNodes.Count; i++) {
                if (_Root.ChildNodes[i].Name == "property") {
                    _ls.Add(BuildAntProperty(_Root.ChildNodes[i]));
                }
            }

            _result = new BaseAntProperty[_ls.Count];
            for (int j = 0; j < _ls.Count; j++) {
                _result[j] = _ls[j] as BaseAntProperty;
            }
            
            return _result;
        } 

        protected virtual BaseAntTarget BuildAntTarget(XmlNode aNode) {
            string _Description = "";
            string _Name = "";
            XmlAttribute _Attr = null;

            _Attr = (XmlAttribute) aNode.Attributes.GetNamedItem("name");

            if (_Attr != null) {
                _Name = _Attr.Value; 
            } else {
                throw new Exception("Expected target name");
            }

            _Attr = (XmlAttribute) aNode.Attributes.GetNamedItem("description");

            if (_Attr != null) {
                _Description = _Attr.Value; 
            } 

            BaseAntTarget _result = CreateAntTarget(_Name, _Description, aNode.OuterXml);

            return _result;
        }

        protected virtual BaseAntTarget[] BuildAntTargets() {
            ArrayList _ls = new ArrayList();
			BaseAntTarget[] _result;
			XmlNode _Root = null;

            _Root = fXml.DocumentElement;

            for (int i = 0; i < _Root.ChildNodes.Count; i++) {
                if (_Root.ChildNodes[i].Name == "target") {
                    _ls.Add(BuildAntTarget(_Root.ChildNodes[i]));
                }
            }

			_result = new BaseAntTarget[_ls.Count];
			for (int j = 0; j < _ls.Count; j++) {
                _result[j] = _ls[j] as BaseAntTarget;
            }
            
            return _result;
        } 

        protected virtual void FillAntProject() {
            XmlNode  _Node = null;
            XmlAttribute _Attr = null;

            if (fXml.DocumentElement != null) {               
                _Node = fXml.DocumentElement;

                if (_Node.Name == "project") {
                    // Set the Name value
                    _Attr = (XmlAttribute) _Node.Attributes.GetNamedItem("name");

                    if (_Attr != null) {
                        fProjectName = _Attr.Value;                     
                    }

                    // Set the Default value
                    _Attr = (XmlAttribute) _Node.Attributes.GetNamedItem("default");

                    if (_Attr != null) {
                        fDefault = _Attr.Value;                     
                    }

                    // Build the Target
					fTargets = BuildAntTargets();
                    fProperties = BuildAntProperties();
                } else {
                    MessageBox.Show("Invalid project");
                }

            }
		}

		public abstract BaseAntProperty CreateAntProperty(string aName, string aValue);

		public abstract BaseAntTarget CreateAntTarget(string aName, string aDescription, string aData);

		// *************************************************************************
		//                                Properties
        // *************************************************************************

        public string Default {
            get {
                return fDefault;
            }
        }

        public string FileName {
            get {
                return fFileName;
            }
            set {
                fFileName = value;
            }
        }

		public string ProjectName {
			get 
			{
				return fProjectName;
			}
		}

        [Browsable(false)]
		public BaseAntProperty[] Properties {
			get {
				return fProperties;
			}
		}

		[Browsable(false)]
        public BaseAntTarget[] Targets {
            get {
                return fTargets;
            }
        }

        [Browsable(false)]
		public XmlDocument Xml {
			get {				
				return fXml;
			}
		}
	}
}
